/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.fluid;

import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class HoneyFluid
extends ForgeFlowingFluid {
    public static final ResourceLocation STILL = new ResourceLocation("productivebees", "block/honey/still");
    public static final ResourceLocation FLOWING = new ResourceLocation("productivebees", "block/honey/flow");
    public static final ResourceLocation OVERLAY = new ResourceLocation("productivebees", "block/honey/overlay");

    protected HoneyFluid() {
        super(new ForgeFlowingFluid.Properties(ModFluids.HONEY, ModFluids.HONEY_FLOWING, FluidAttributes.builder((ResourceLocation)STILL, (ResourceLocation)FLOWING).overlay(OVERLAY).translationKey("fluid.productivebees.honey").color(-14058).density(3000).viscosity(6000)).bucket(ModItems.HONEY_BUCKET));
    }

    public Fluid m_5615_() {
        return (Fluid)ModFluids.HONEY_FLOWING.get();
    }

    public Fluid m_5613_() {
        return (Fluid)ModFluids.HONEY.get();
    }

    public void m_7450_(Level worldIn, BlockPos pos, FluidState state, Random random) {
        BlockPos blockpos = pos.m_7494_();
        if (random.nextInt(100) == 0 && !worldIn.m_8055_(blockpos).m_60819_().equals(state)) {
            worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11968_, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Nullable
    public ParticleOptions m_7792_() {
        return ParticleTypes.f_123779_;
    }

    public int m_6719_(LevelReader worldIn) {
        return worldIn.m_6042_().m_63951_() ? 6 : 3;
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn.m_205067_(ModTags.HONEY);
    }

    public int m_6713_(LevelReader worldIn) {
        return worldIn.m_6042_().m_63951_() ? 1 : 2;
    }

    public int m_6718_(LevelReader worldIn) {
        return worldIn.m_6042_().m_63951_() ? 10 : 30;
    }

    public int m_6886_(Level world, BlockPos pos, FluidState state, FluidState FluidState2) {
        int i = this.m_6718_((LevelReader)world);
        if (!(state.m_76178_() || FluidState2.m_76178_() || ((Boolean)state.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)FluidState2.m_61143_((Property)f_75947_)).booleanValue() || !(FluidState2.m_76155_((BlockGetter)world, pos) > state.m_76155_((BlockGetter)world, pos)) || world.m_5822_().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public boolean shouldFreeze(LevelReader pLevel, Biome biome, BlockPos pos) {
        if (!biome.m_198906_(pos) && pos.m_123342_() >= pLevel.m_141937_() && pos.m_123342_() < pLevel.m_151558_() && pLevel.m_45517_(LightLayer.BLOCK, pos) < 10) {
            BlockState blockstate = pLevel.m_8055_(pos);
            FluidState fluidstate = pLevel.m_6425_(pos);
            if (fluidstate.m_76152_() == ModFluids.HONEY.get() && blockstate.m_60734_() instanceof LiquidBlock) {
                boolean flag;
                boolean bl = flag = this.isHoneyAt(pLevel, pos.m_142125_()) && this.isHoneyAt(pLevel, pos.m_142126_()) && this.isHoneyAt(pLevel, pos.m_142127_()) && this.isHoneyAt(pLevel, pos.m_142128_());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isHoneyAt(LevelReader level, BlockPos pPos) {
        return level.m_6425_(pPos).m_205070_(ModTags.HONEY);
    }

    public static class Source
    extends HoneyFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

